## BizApp 管理コンソール

Next.js (App Router) と MariaDB を利用した、ヘッダ・ハンバーガーメニュー付き左メニュー・メインパネルから構成されるサンプル管理アプリです。左メニューの `[ユーザー]` からユーザー一覧・作成・更新・削除を行えます。`[プロジェクト]` メニューはプレースホルダーのみ用意しています。

## 必要要件

- Node.js 18 以上 (動作確認: Node.js 24)
- MariaDB 10.6 以上 または MySQL 8 互換サーバー

## セットアップ

1. 依存関係のインストール

   ```bash
   npm install
   ```

2. 環境変数ファイルの作成  
   `.env.example` をコピーして `.env` を作成し、接続情報を修正してください。

   ```bash
   cp .env.example .env
   # DATABASE_URL="mysql://username:password@localhost:3306/bizapp" を編集
   ```

3. データベースとテーブルの初期化

   MariaDB 上にデータベースを作成し、`scripts/create_users_table.sql` を実行します。

   ```bash
   mysql -u <user> -p <database_name> < scripts/create_users_table.sql
   ```

4. 開発サーバーの起動

   ```bash
   npm run dev
   ```

   ブラウザで [http://localhost:3000](http://localhost:3000) を開きます。

## 主な機能

- ハンバーガーアイコンで開閉できる左メニュー
- MariaDB に保存されたユーザー情報の取得・作成・更新・削除
- 新規作成 / 更新 / 削除の各操作時にモーダルダイアログを表示
- API ルート: `GET/POST /api/users`, `PUT/DELETE /api/users/:id`

## 環境変数

- `DATABASE_URL` … MariaDB/MySQL の接続文字列 (`mysql://user:pass@host:port/dbname` 形式)

## 注意事項

- 同一メールアドレスは登録できないようにユニーク制約を設定しています。
- `[プロジェクト]` メニューは現時点ではプレースホルダー表示のみです。
