import mysql, { Pool } from "mysql2/promise";

let cachedPool: Pool | null = null;

/**
 * Returns a singleton connection pool for MariaDB/MySQL access.
 * Uses DATABASE_URL connection string (mysql://user:pass@host:port/dbname).
 */
export function getPool(): Pool {
  if (cachedPool) {
    return cachedPool;
  }

  const url = process.env.DATABASE_URL;

  if (!url) {
    throw new Error(
      "DATABASE_URL is not set. Please configure it in your environment."
    );
  }

  cachedPool = mysql.createPool({
    uri: url,
    waitForConnections: true,
    connectionLimit: 10,
    namedPlaceholders: true,
  });

  return cachedPool;
}

/**
 * Close and reset the pool. Useful for test teardown.
 */
export async function resetPool(): Promise<void> {
  if (cachedPool) {
    await cachedPool.end();
    cachedPool = null;
  }
}
